/*
 * Decompiled with CFR 0.152.
 */
package util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.Set;
import org.json.JSONObject;

public class FileSystem {
    private static final String dataDirPath = "../dataRaw";
    private static String assnId = null;

    public static void setAssnId(String assnId) {
        System.out.println("Assignment Id: " + assnId);
        FileSystem.assnId = assnId;
    }

    public static String getAssnId() {
        return assnId;
    }

    public static File getAssnDir() {
        File dataDir = new File(dataDirPath);
        return new File(dataDir, FileSystem.getAssnId());
    }

    public static File getDataDir() {
        return new File(dataDirPath);
    }

    public static String getFileContents(File file) {
        Scanner codeIn = null;
        String content = "";
        try {
            try {
                codeIn = new Scanner(file);
                while (codeIn.hasNextLine()) {
                    content = String.valueOf(content) + codeIn.nextLine() + "\n";
                }
            }
            catch (Exception e) {
                if (codeIn != null) {
                    codeIn.close();
                }
                return null;
            }
        }
        finally {
            if (codeIn != null) {
                codeIn.close();
            }
        }
        return content;
    }

    public static List<String> getFileLines(File file) {
        Scanner codeIn = null;
        try {
            ArrayList<String> content = new ArrayList<String>();
            codeIn = new Scanner(file);
            while (codeIn.hasNextLine()) {
                content.add(codeIn.nextLine());
            }
            codeIn.close();
            return content;
        }
        catch (Exception e) {
            if (codeIn != null) {
                codeIn.close();
            }
            return null;
        }
    }

    public static Map<String, Integer> getFileMap(File file) {
        return FileSystem.getFileMap(file, "\t");
    }

    public static <T> Set<T> getFileSet(File file) {
        List<String> lines = FileSystem.getFileLines(file);
        if (lines == null) {
            return null;
        }
        HashSet<String> fileSet = new HashSet<String>();
        for (String line : lines) {
            fileSet.add(line);
        }
        return fileSet;
    }

    public static Map<String, Integer> getFileMap(File file, String delimiter) {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        List<String> lines = FileSystem.getFileLines(file);
        for (String line : lines) {
            String[] row = line.split(delimiter);
            if (row.length != 2) {
                throw new RuntimeException("There should only be two cols");
            }
            String id = row[0];
            int count = Integer.parseInt(row[1]);
            map.put(id, count);
        }
        return map;
    }

    public static int[][] getFileMatrix(File file) {
        List<String> lines = FileSystem.getFileLines(file);
        int rows = lines.size();
        String firstRow = lines.get(0);
        int cols = firstRow.split(",").length;
        int[][] matrix = new int[rows][cols];
        int r = 0;
        while (r < rows) {
            String line = lines.get(r);
            String[] csvCols = line.split(",");
            int c = 0;
            while (c < cols) {
                int value;
                String strValue = csvCols[c];
                matrix[r][c] = value = Integer.parseInt(strValue);
                ++c;
            }
            ++r;
        }
        return matrix;
    }

    public static Map<String, String> getFileMapString(File file) {
        HashMap<String, String> map = new HashMap<String, String>();
        List<String> lines = FileSystem.getFileLines(file);
        for (String line : lines) {
            String[] row = line.split(",");
            if (row.length != 2) {
                System.out.println(line);
                throw new RuntimeException("There should only be two cols");
            }
            String id = row[0].trim();
            String value = row[1].trim();
            if (value.equals("null")) continue;
            map.put(id, value);
        }
        return map;
    }

    public static void createFile(File f, String text) {
        block12: {
            FileWriter file = null;
            try {
                try {
                    file = new FileWriter(f);
                    file.write(text);
                    file.flush();
                    file.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                    if (file == null) break block12;
                    try {
                        file.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            finally {
                if (file != null) {
                    try {
                        file.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }

    public static void createFile(File dir, String fileName, String text) {
        dir.mkdirs();
        File f = new File(dir, fileName);
        FileSystem.createFile(f, text);
    }

    public static void createMapFile(File dir, String fileName, Map<String, String> map) {
        String txt = "";
        for (String key : map.keySet()) {
            String value = map.get(key);
            txt = String.valueOf(txt) + key + "," + value + "\n";
        }
        FileSystem.createFile(dir, fileName, txt);
    }

    public static void createFile(File dir, String fileName, List<String> lines) {
        String txt = "";
        int i = 0;
        while (i < lines.size()) {
            txt = String.valueOf(txt) + lines.get(i);
            if (i != lines.size() - 1) {
                txt = String.valueOf(txt) + "\n";
            }
            ++i;
        }
        FileSystem.createFile(dir, fileName, txt);
    }

    public static List<File> listNumericalFiles(File path) {
        if (!path.exists()) {
            return new ArrayList<File>();
        }
        ArrayList<File> fileList = new ArrayList<File>();
        File[] fileArray = path.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File f = fileArray[n2];
            String name = FileSystem.getNameWithoutExtension(f);
            try {
                int intName = Integer.parseInt(name);
                fileList.add(f);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            ++n2;
        }
        Collections.sort(fileList, new Comparator<File>(){

            @Override
            public int compare(File f1, File f2) {
                String n1 = FileSystem.getNameWithoutExtension(f1);
                String n2 = FileSystem.getNameWithoutExtension(f2);
                try {
                    int i1 = Integer.parseInt(n1);
                    int i2 = Integer.parseInt(n2);
                    return i1 - i2;
                }
                catch (NumberFormatException e) {
                    throw new AssertionError((Object)e);
                }
            }
        });
        return fileList;
    }

    public static List<File> listFiles(File path) {
        if (!path.exists()) {
            return new ArrayList<File>();
        }
        return new ArrayList<File>(Arrays.asList(path.listFiles()));
    }

    public static List<File> listDirs(File path) {
        ArrayList<File> dirs = new ArrayList<File>();
        for (File f : FileSystem.listFiles(path)) {
            if (!f.isDirectory()) continue;
            dirs.add(f);
        }
        return dirs;
    }

    public static String getNameWithoutExtension(File file) {
        int p;
        String fileName = file.getName();
        if (!fileName.contains(".")) {
            return fileName;
        }
        String subName = "";
        int i = fileName.lastIndexOf(46);
        if (i > (p = Math.max(fileName.lastIndexOf(47), fileName.lastIndexOf(92)))) {
            subName = fileName.substring(0, i);
        }
        return subName;
    }

    public static String getExtension(File file) {
        int p;
        String fileName = file.getName();
        String extension = "";
        int i = fileName.lastIndexOf(46);
        if (i > (p = Math.max(fileName.lastIndexOf(47), fileName.lastIndexOf(92)))) {
            extension = fileName.substring(i + 1);
        }
        return extension;
    }

    public static void copyFile(String from, String to) {
        File source = new File(from);
        File dest = new File(to);
        AbstractInterruptibleChannel inputChannel = null;
        AbstractInterruptibleChannel outputChannel = null;
        try {
            try {
                dest.createNewFile();
                inputChannel = new FileInputStream(source).getChannel();
                outputChannel = new FileOutputStream(dest).getChannel();
                ((FileChannel)outputChannel).transferFrom((ReadableByteChannel)((Object)inputChannel), 0L, ((FileChannel)inputChannel).size());
                inputChannel.close();
                outputChannel.close();
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
                if (inputChannel != null) {
                    try {
                        inputChannel.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                if (outputChannel != null) {
                    try {
                        outputChannel.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            catch (IOException e) {
                block29: {
                    e.printStackTrace();
                    if (inputChannel == null) break block29;
                    try {
                        inputChannel.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                if (outputChannel != null) {
                    try {
                        outputChannel.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        finally {
            if (inputChannel != null) {
                try {
                    inputChannel.close();
                }
                catch (IOException iOException) {}
            }
            if (outputChannel != null) {
                try {
                    outputChannel.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static JSONObject loadJson(File f) {
        String jsonStr = FileSystem.getFileContents(f);
        JSONObject json = new JSONObject(jsonStr);
        return json;
    }
}

