/*
 * Decompiled with CFR 0.152.
 */
package util;

import java.util.ArrayList;
import java.util.List;

public class Histogram {
    private double minBound;
    private double maxBound;
    private double binSize;
    List<Integer> counts;

    public Histogram(double minBound, double maxBound, double size) {
        this.binSize = size;
        this.maxBound = maxBound;
        this.minBound = minBound;
        this.counts = new ArrayList<Integer>();
        double diff = maxBound - minBound;
        int numBuckets = (int)(diff / size) + 1;
        int i = 0;
        while (i < numBuckets) {
            this.counts.add(0);
            ++i;
        }
    }

    public void addPoint(double x) {
        int binIndex = this.getBinIndex(x);
        int newCount = this.counts.get(binIndex) + 1;
        this.counts.set(binIndex, newCount);
    }

    private int getBinIndex(double x) {
        double pos = (x - this.minBound) / this.binSize;
        return (int)pos;
    }

    public String toString() {
        String str = "";
        int i = 0;
        while (i < this.counts.size()) {
            double lowerBound = this.minBound + (double)i * this.binSize;
            double upperBound = lowerBound + this.binSize;
            int count = this.counts.get(i);
            String lowerStr = String.format("%.2f", lowerBound);
            String upperStr = String.format("%.2f", upperBound);
            String boundStr = lowerStr;
            System.out.println(String.valueOf(boundStr) + "\t" + count);
            ++i;
        }
        return str;
    }

    public static void main(String[] args) {
        Histogram h = new Histogram(0.0, 2.5, 0.1);
        h.addPoint(0.0);
        h.addPoint(0.05);
        h.addPoint(0.1);
        h.addPoint(0.12);
        h.addPoint(0.45);
        System.out.println(h);
    }
}

