/*
 * File: HolePuncher.java
 * -----------------------------
 * Draws a small circle where the user clicks
 */

import java.awt.Color;
import java.awt.event.MouseEvent;

import acm.graphics.*;
import acm.program.*;
import acm.util.RandomGenerator;

public class HolePuncher extends GraphicsProgram {

	/* The size (in pixels) of a single hole punch */
	private static final int HOLE_SIZE = 15;
	
	// Step 1: define the mouse method for the event you want to act on
	// Must match the prototype EXACTLY!
	public void mouseClicked(MouseEvent e) {
		
		// 2. You can use the mouse event variable to get
		// the location of the mouse
		double x = e.getX();
		double y = e.getY();
		
		// 3. You can do something in response to the event
		addHole(x, y);
	}

	/**
	 * Method: Add Hole
	 * ----------------
	 * Places a black circle which is centered around the given
	 * parameters.
	 * @param centerX, the x pixel coordinate for the circle center 
	 * @param centerY, the y pixel coordinate for the circle center
	 */
	private void addHole(double centerX, double centerY) {
		GOval hole = new GOval(HOLE_SIZE, HOLE_SIZE);
		hole.setFilled(true);
		double holeX = centerX - HOLE_SIZE / 2.0;
	    double holeY = centerY - HOLE_SIZE / 2.0;
		add(hole, holeX, holeY);
	}

}