/*
 * File: MouseTracker.java
 * -----------------
 * This is a program displays a GRect that follows
 * the mouse around the screen.
 * 
 * This program requires an instance variable to store the GRect so
 * its location can be changed in the mouseMoved method. 
 */

import acm.program.*;
import acm.graphics.*;
import java.awt.*;
import java.awt.event.*;

public class MouseTracker extends GraphicsProgram {
	
	private static final int SQUARE_SIZE = 50;
	
	// We make an instance variable for square so both the run method
	// and the mouseMoved method can access it
	private GRect square;
	
	public void run() {
		square = new GRect(0, 0, SQUARE_SIZE, SQUARE_SIZE);
		square.setFilled(true);
		square.setColor(Color.BLUE);
		add(square);
	}
	
	// Step 1: define the mouse method for the event you want to act on
	// Must match the prototype EXACTLY!
	public void mouseMoved(MouseEvent event) {

		// Step 2: get information about the event (here, mouse x and y)
		double mouseX = event.getX();
		double mouseY = event.getY();
		
		// Step 3: Do something in response to this event (move rect to be
		// centered at mouse location)
		double squareX = mouseX - square.getWidth() / 2.0;
		double squareY = mouseY - square.getHeight() / 2.0;
		square.setLocation(squareX, squareY);
	}
}
