/*
 * File: WhackAMole.java
 * -----------------
 * This program plays the game Whack-A-Mole. Every half second, a mole appears
 * somewhere random on the screen. If the user clicks a mole, the mole disappears
 * and the user's score, displayed in the upper-left corner in a GLabel, increases by 1.
 * The game plays until the user gets 10 points.
 *
 * This program requires instance variables to store the score label and number so they
 * can be changed in the mouseClicked method.
 */
import acm.graphics.*;
import acm.program.*;
import acm.util.*;
import java.awt.*;
import java.awt.event.*;

public class WhackAMole extends GraphicsProgram {
	
	// Points the user needs to get to win
	private static final int MAX_SCORE = 10;

	// Pause in between adding moles
	private static final double PAUSE_TIME = 500;
	
	// Path to picture of mole
	private static final String MOLE_FILE = "res/mole.png";
	
	// Pretty font for display score to user
	private static final String SCORE_FONT = "Monospaced-Bold-20";

	// This instance variable tracks how many moles the user has whacked
	private int score;
	
	// This instance variable displays the score to the user
	private GLabel scoreLabel;
	
	public void run() {
		score = 0;
		makeScoreLabel();
		
		// Continuously add a new mole image in a random location every 0.5 seconds
		// until the user gets MAX_SCORE points
		while (score < MAX_SCORE) {
			GImage mole = new GImage(MOLE_FILE);
			RandomGenerator rgen = RandomGenerator.getInstance();
			double x = rgen.nextDouble(0, getWidth() - mole.getWidth());
			double y = rgen.nextDouble(0, getHeight() - mole.getHeight());
			add(mole, x, y);
			
			pause(PAUSE_TIME);
		}		
	}
	
	/*
	 * Initializes our score label as a new GLabel displaying 0 in the upper-left corner
	 */
	private void makeScoreLabel() {
		scoreLabel = new GLabel("Score: " + score);
		scoreLabel.setFont(SCORE_FONT);
		add(scoreLabel, 0, scoreLabel.getHeight());
	}
	
	/*
	 * When the mouse is clicked, if there is a mole, remove it and increment the score.
	 * Otherwise, do nothing.
	 */
	public void mouseClicked(MouseEvent e) {
		double x = e.getX();
		double y = e.getY();
		
		GObject maybeMole = getElementAt(x, y);
		
		// If there is no mole here, then maybeMole will be null. remove(maybeMole) will crash!
		if (maybeMole != null) {
			remove(maybeMole);
			score++;
			scoreLabel.setText("Score: " + score);
		}
	}
}