/*
 * File: ReferenceVsValueSoln.java
 * --------------------
 * A program that shows that primitives are passed by value and 
 * objects are passed by reference.
 */

import java.awt.*;

import acm.graphics.*;
import acm.program.*;

public class ReferenceVsValueSoln extends GraphicsProgram {

	public void run() {	
		
		int primitiveInt = 0;
		// This method WILL NOT change the int.
		// When we pass a primitive value into a method,
		// We're passing in a COPY of that value.
		changeInt(primitiveInt);
		GLabel intLabel = new GLabel("primitiveInt: " + primitiveInt, 0, 50);
		add(intLabel);
		
		
		GRect objectRect = new GRect(100, 100);
		objectRect.setFilled(true);
		objectRect.setColor(Color.BLUE);
		add(objectRect, 0, 100);
		// This method WILL change the rect.
		// When we pass an object into a method,
		// We're passing in a REFERENCE TO that object.
		changeRect(objectRect);
	}
	
	/*
	 * Adds 10 to an int passed into it.
	 */
	private void changeInt(int primitiveInt) {
		primitiveInt += 10;
	}
	
	/*
	 * Removes the fill of a rect and colors it green.
	 */
	private void changeRect(GRect objectRect) {
		objectRect.setFilled(false);
		objectRect.setColor(Color.GREEN);	
	}
}

