/*
 * File: StartsWith.java
 * -------------------------
 * This program checks whether one string starts with another string.
 */

import acm.program.*;

public class StartsWith extends ConsoleProgram {
	
	public void run() {
		setFont("Courier-28");
		
		while (readBoolean("run?", "y", "n")) {
			String s1 = readLine("Enter a word: ");
			String s2 = readLine("Enter a prefix to check: ");
			boolean isPrefix = startsWith(s1, s2);
			
			println("is prefix => " + isPrefix);
			println();
		}
	}
	
	/*
	 * startsWith
	 * ----------
	 * Returns whether s1 starts with s2.
	 * You can assume that len(s1) >= len(s2)
	 */
	private boolean startsWith(String s1, String s2) {
		for (int i = 0; i < s2.length(); i++) {
			if (s1.charAt(i) != s2.charAt(i)) {
				// if we ever get a mismatch, return false right away
				return false;
			}
		}
		
		// if we get here, all characters in s2 matched characters
		// in s1, so we can return true
		return true;
	}
}


