/*
 * File: Choosing Secrets.java
 * -----------------------
 * We use promptUserForFile to ask the user which
 * file (secret) they would like to use!
 */

import acm.program.*;

import java.util.*;
import java.io.*;

public class ChoosingSecrets extends ConsoleProgram {


	public void run(){	
		try {
			String filename = promptUserForFile("What file do you want to open?");
			
			Scanner input = new Scanner(new File(filename));
			while(input.hasNextLine()) {
				String line = input.nextLine();
				println(line);
			}
			input.close();
			
		} catch (FileNotFoundException ex) {
			println("Couldn't open that secret!");
		}
	}

}


