/*
 * File: ReadingBreakoutHighScoresSoln.java
 * --------------------
 * This reads a name, score, and time from "BreakoutScores.txt"
 * and prints it out.
 */


import acm.program.*;

import java.io.*;
import java.util.*;


public class ReadingBreakoutHighScoresSoln extends ConsoleProgram {

	public void run() {	
		
		try {
			Scanner input = new Scanner(new File("BreakoutScores.txt"));
			while(input.hasNextLine()) {
				// Reads a String from the input
				String name = input.next();
				// Reads an int from the input
				int bricks = input.nextInt();
				// Reads a double from the input
				double secs = input.nextDouble();
				println(name + " cleared " + bricks + " bricks in " + secs + " seconds.");
			} 
		} catch (FileNotFoundException ex) {
			println("Couldn't read Breakout High Scores!");
		}	
	}
	
	
}

