/*
 * File: ReadingDukesDiarySoln.java
 * -----------------------
 * This file will read and print out an entry from
 * Duke's diary!
 */

import acm.program.*;

import java.util.*;
import java.io.*;

public class ReadingDukesDiarySoln extends ConsoleProgram {


	public void run(){	
		printingDukesDiary();
		countingWordsInDukesDiary();
	}
	
	/**
	 * This will print out the contents of Duke's Diary.
	 */
	private void printingDukesDiary() {
		try {
			Scanner input = new Scanner(new File("DukesDiary.txt"));
			while(input.hasNextLine()) {
				String line = input.nextLine();
				println(line);
			}
			input.close();
		} catch (IOException ex) {
			println("The error is: " + ex);
		}
	}
	
	/**
	 * This will print out the number of words in each line of
	 * Duke's Diary.
	 */
	private void countingWordsInDukesDiary() {
		try {
			Scanner input = new Scanner(new File("DukesDiary.txt"));
			while(input.hasNextLine()) {
				Scanner tokens = new Scanner(input.nextLine());
				int numWords = 0;
				
				while(tokens.hasNext()) {
					String word = tokens.next();
					numWords++;
				}
				println("This line has " + numWords + " words.");
				tokens.close();

			}
			input.close();
		} catch (FileNotFoundException ex) {
			println("Couldn't open Duke's Diary!");
		}
	}




}


