/*
 * File: Choosing Secrets.java
 * -----------------------
 * We use promptUserForFile to ask the user which
 * file (secret) they would like to use!
 */

import acm.program.*;

import java.util.*;
import java.io.*;

public class CatWakeUpsSoln extends ConsoleProgram {
	
	private static final int DAYS_IN_WEEK = 7;

	public void run(){
		
		// There are 7 days in a week and the number of wake ups would be an int.
		int[] catWakeUps = new int[DAYS_IN_WEEK];
		
		// 7 times, we'll ask our user how many times they were woken up.
		for(int day = 0; day < catWakeUps.length; day++) {
			catWakeUps[day] = readInt("How many times did a cat wake you up on Day " + (day + 1) + "?");
		}
		
		int day = readInt("What day would you like info about?");
		while(day != -1) {
			// While our days start at 1, our array indices start at 0!
			int index = day - 1;
			
			println("On day " + day + " you were woken up " + catWakeUps[index] + " times.");
		
			day = readInt("What day would you like info about?");
		}
		
	}
	

}


