/*
 * File: CoffeeSpendingSoln.java
 * -----------------------
 * This program will tells you the most
 * money you spent on coffee in a day.
 */

import acm.program.*;

import java.util.*;
import java.io.*;

public class CoffeeSpendingSoln extends ConsoleProgram {
	
	private static final int DAYS_IN_WEEK = 7;

	public void run(){
		
		// There are 7 days in a week and money is represented as a double.
		double[] coffeeSpending = new double[DAYS_IN_WEEK];
		
		for(int day = 0; day < coffeeSpending.length; day++) {
			coffeeSpending[day] = readDouble("How much did you spend on coffee on Day " + (day + 1) + "?");
		}
		
		shortFindMaxSpending(coffeeSpending);
		longFindMaxSpending(coffeeSpending);

	}
	
	/**	
	 * This method sorts the array and returns the final element
	 * to give you the max amount you spent on coffee.
	 * 
	 * @param amountSpent
	 */
	private void shortFindMaxSpending(double[] amountSpent) {
		Arrays.sort(amountSpent);
		// Now that it's sorted, the last element is the biggest element.
		int lastElement = amountSpent.length - 1;
		println("The most you spent was " + amountSpent[lastElement]);
	}
	
	/**	
	 * This method iterates through the array and keeps 
	 * comparing elements to find the max amount you 
	 * spent on coffee.
	 * 
	 * @param amountSpent
	 */
	private void longFindMaxSpending(double[] amountSpent) {
		double maxSpent = 0; 
		for(int day = 0; day < amountSpent.length; day++) {
			double currentSpending = amountSpent[day];
			
			if(currentSpending > maxSpent) {
				maxSpent = currentSpending;
			}
		}
		
		println("The most you spent was " + maxSpent);
		
	}

}


