/* File: Pointillism.java
 * --------------------------
 * This program mimics the "pointillism" artistic technique
 * by randomly picking pixels from an image and drawing that
 * pixel as a small GOval on the screen.
 */

import java.awt.*;
import acm.graphics.*;
import acm.program.*;
import acm.util.*;

public class Pointillism extends GraphicsProgram {

	private static final int NUM_POINTS = 15000;
	private static final int CIRCLE_RADIUS = 6;
	private static final String IMG_NAME = "res/passionflower.jpg";
	
	private RandomGenerator rgen = RandomGenerator.getInstance();
	
	public void run() {	
		// setup
		setBackground(Color.BLACK);
		GImage img = new GImage(IMG_NAME);
		setCanvasSize(img.getWidth(), img.getHeight());

		// get the matrix of pixels for the image
		int[][] pixels = img.getPixelArray();
				
		// TODO: pointillism!
		
	}

	/*
	 * addColoredCircle
	 * ----------------
	 * This method adds a CIRCLE_RADIUS GOval of the given
	 * color at the given location on the canvas.
	 */
	private void addColoredCircle(int row, int col, Color c) {
		double size = CIRCLE_RADIUS * 2;
		GOval oval = new GOval(size, size);
		oval.setFilled(true);
		oval.setColor(c);
		add(oval, col - CIRCLE_RADIUS, row - CIRCLE_RADIUS);
	}
}
