/*
 * File: Berries.java
 * -------------------
 * We've gone berry picking! This program animates falling berries.
 */

import acm.program.*;
import acm.util.*;
import java.applet.*;
import java.awt.Color;
import java.io.*;
import java.util.*;

import acm.graphics.*;

public class Berries extends GraphicsProgram {

	private static final int BERRY_SIZE = 40;
	private static final int PAUSE_TIME = 15;
	private static final int VY = 2;
	
	private RandomGenerator rgen = new RandomGenerator();

	public void run() {
		
		// TODO: Modify this program to animate adding many falling berries!
		// right now, it only makes and animates a single berry

		GImage berry = makeNewBerry();
		
		while(true) {
			// update world
			if(berry.getY() + BERRY_SIZE < getHeight()) {
				berry.move(0, VY);
			}

			// pause
			pause(PAUSE_TIME);
		}
	}

	private GImage makeNewBerry() {
		double x = rgen.nextInt(getWidth() - BERRY_SIZE);
		GImage berry = getBerryImage();
		berry.setSize(BERRY_SIZE, BERRY_SIZE);
		add(berry, x, -BERRY_SIZE);
		return berry;
	}

	private GImage getBerryImage() {
		int n = rgen.nextInt(3);
		if (n == 0) return new GImage("res/raspberry.png");
		if (n == 1) return new GImage("res/blueberry.png");
		return new GImage("res/blackberry.png");
	}
}
