/*
 * File: BerriesSoln.java
 * ----------------------
 * We've gone berry picking! This program animates falling berries.
 */

import acm.program.*;
import acm.util.*;
import java.applet.*;
import java.awt.Color;
import java.io.*;
import java.util.*;

import acm.graphics.*;

public class BerriesSoln extends GraphicsProgram {

	private static final int BERRY_SIZE = 40;
	private static final int PAUSE_TIME = 15;
	private static final int VY = 2;
	
	private RandomGenerator rgen = new RandomGenerator();

	private ArrayList<GImage> berryList = new ArrayList<GImage>();

	public void run() {

		while(true) {
			// update world
			makeNewBerry();
			moveBerries();

			// pause
			pause(PAUSE_TIME);
		}

	}

	private void moveBerries() {
		for(GImage berry : berryList) {
			if(berry.getY() + BERRY_SIZE < getHeight()) {
				berry.move(0, VY);
			}
		}
	}

	private void makeNewBerry() {
		// make a new berry with 5% probability
		if(rgen.nextBoolean(0.05)) {
			double x = rgen.nextInt(getWidth() - BERRY_SIZE);
			GImage berry = getBerryImage();
			berry.setSize(BERRY_SIZE, BERRY_SIZE);
			add(berry, x, -BERRY_SIZE);
			berryList.add(berry);
		}
	}
	
	private GImage getBerryImage() {
		int n = rgen.nextInt(3);
		if (n == 0) return new GImage("res/raspberry.png");
		if (n == 1) return new GImage("res/blueberry.png");
		return new GImage("res/blackberry.png");
	}
}
