/*
 * File: ReverseFileSoln.txt
 * -------------------------
 * This program reads in lines from a file and prints them
 * out in reverse order.
 */

import acm.program.*;
import java.util.*;
import java.io.*;

public class ReverseFileSoln extends ConsoleProgram {
	
	private static final String FILENAME = "res/minipoem.txt";
	
	public void run() {
		
		try {
			Scanner scanner = new Scanner(new File(FILENAME));
			
			// make an ArrayList to store the lines!
			ArrayList<String> lines = new ArrayList<String>();
			
			// read in all the lines from the file
			while (scanner.hasNextLine()) {
				String line = scanner.nextLine();
				lines.add(line);
			}
			
			// print list backwards
			println("\nReversed:");
			for (int i = lines.size() - 1; i >= 0; i--) {
				String line = lines.get(i);
				println(line);
			}
			
			scanner.close();
		} catch (IOException e) {
			println("Could not read file: " + e);
		}
	}
}
