/*
 * File: TripPlannerSoln.java
 * ----------------------
 * A program that prompts for a list of cities, and them reprompts the user
 * to enter them in the order they want to visit them.  At the end, prints
 * out the ordering they have entered.
 * 
 * EXAMPLE OUTPUT:
 *
 * ** STEP 1 **
 * Enter a city: Florence
 * Enter a city: Seattle
 * Enter a city: Singapore
 * Enter a city: 
 * 
 * ** STEP 2 **
 * That's an exciting list!  Enter the order you'd like to visit those cities in.
 * Cities remaining: [Florence, Seattle, Singapore]
 * Next city to visit: Seattle
 * Cities remaining: [Florence, Singapore]
 * Next city to visit: Singapore
 * Cities remaining: [Florence]
 * Next city to visit: London
 * That city is not on your list! Maybe on another trip.
 * Cities remaining: [Florence]
 * Next city to visit: Florence
 * 
 * ** STEP 3 **
 * Great! Your itinerary is ready:
 * [Seattle, Singapore, Florence]
 */

import java.util.*;
import acm.program.*;

public class TripPlannerSoln extends ConsoleProgram {
	
	public void run() {
		// Step 1: Prompt for cities
		ArrayList<String> enteredCities = readCities();
		
		// Step 2: Reprompt for order of cities
		ArrayList<String> orderedCities = new ArrayList<>();
		
		println("That's an exciting list!  Enter the order you'd like to visit those cities in.");
		
		while (!enteredCities.isEmpty()) {
			println("Cities remaining: " + enteredCities);
			String city = readLine("Next city to visit: ");
			
			if (enteredCities.contains(city)) {
				enteredCities.remove(city);
				orderedCities.add(city);
			} else {
				println("That city is not on your list! Maybe on another trip.");
			}
		}
		
		// Step 3: print out itinerary -> order to visit the cities
		println("Great! Your itinerary is ready:");
		println(orderedCities);
	}
	
	/* Returns the list of cities the user wants to visit,
	 * prompting until the user enters the empty string.
	 */
	private ArrayList<String> readCities() {
		ArrayList<String> cities = new ArrayList<String>();
		
		String city = readLine("Enter a city: ");
		while (city.length() > 0) {
			cities.add(city);
			city = readLine("Enter a city: ");
		}
		
		return cities;
	}
}
