/*
 * File: CountingWordsSoln.java
 * -----------------------
 * Code that counts words in a file.
 */

import acm.program.*;

import java.util.*;
import java.io.*;

public class CountingWordsSoln extends ConsoleProgram {

	private static final String TEXT = "SecretFile.txt";

	public void run(){
		HashMap<String, Integer> wordCount = new HashMap<String, Integer>();
		
		fillDictionary(wordCount);
		
		printWordCount(wordCount, 40);

	}
	
	private void printWordCount(HashMap<String, Integer> dict, int threshold) {
		for(String key : dict.keySet()) {
			if(dict.get(key) >= threshold) {
				println(key + ": " + dict.get(key));
			}
		}
	}
	
	private void fillDictionary(HashMap<String, Integer> wordCount){
		try {			
			Scanner input = new Scanner(new File(TEXT));
			while(input.hasNext()) {
				String word = input.next();
				word = word.toLowerCase();
				if(wordCount.containsKey(word)) {
					int newCount = wordCount.get(word) + 1;
					wordCount.put(word, newCount);
				} else {
					wordCount.put(word, 1);
				}
			}
			input.close();
			
		} catch (IOException ex) {
			println("Couldn't open that file!");
		}
	}


}


