/*
 * File: InterestingDictionarySoln.java
 * -----------------------
 * A file that creates an interesting dictionary.
 */

import acm.program.*;

import java.util.*;
import java.io.*;

public class InterestingDictionarySoln extends ConsoleProgram {

	private static final String DICTIONARY = "InterestingDictionary.txt";

	public void run(){
		HashMap<String, String> dict = new HashMap<String, String>();
		
		fillDictionary(dict);
		
		readDefinitions(dict);

	}
	
	private void readDefinitions(HashMap<String, String> dict) {
		println("Available Words: ");
		for(String key : dict.keySet()) {
			println(key);
		}
		String word = readLine("Which word would you like a definition of?");
		while(!word.equals("")) {
			if(dict.containsKey(word)) {
				println("The definition of " + word + " is:");
				println(dict.get(word));
			} else {
				println("Sorry, that wasn't a valid word!");
			}
			
			println();
			word = readLine("Which word would you like a definition of?");
		}
	}
	
	private void fillDictionary(HashMap<String, String> dict){
		try {			
			Scanner input = new Scanner(new File(DICTIONARY));
			while(input.hasNextLine()) {
				String word = input.nextLine();
				String definition = input.nextLine();
				dict.put(word, definition);
			}
			input.close();
			
		} catch (IOException ex) {
			println("Couldn't open that dictionary!");
		}
	}


}


