/*
 * File: SwappingKeysAndValuesSoln.java
 * -----------------------
 * We use promptUserForFile to ask the user which
 * file (secret) they would like to use!
 */

import acm.program.*;

import java.util.*;
import java.io.*;

public class SwappingKeysAndValuesSoln extends ConsoleProgram {

	private static final String DICTIONARY = "InterestingDictionary.txt";

	public void run(){
		HashMap<String, String> dict = new HashMap<String, String>();
		
		fillDictionary(dict);
		
		swapKeysAndValues(dict);
		
		println("Here are the new keys:");
		for(String key : dict.keySet()) {
			println(key);
			println();
		}

	}
	
	private HashMap<String, String> swapKeysAndValues(HashMap<String, String> dict) {
		HashMap<String, String> reversed = new HashMap<String, String>();
		for(String key : dict.keySet()) {
			reversed.put(dict.get(key), key);
		}
		
		dict = reversed;
		
		return dict;	
	}
	
	private void fillDictionary(HashMap<String, String> dict){
		try {			
			Scanner input = new Scanner(new File(DICTIONARY));
			while(input.hasNextLine()) {
				String word = input.nextLine();
				String definition = input.nextLine();
				dict.put(word, definition);
			}
			input.close();
			
		} catch (IOException ex) {
			println("Couldn't open that dictionary!");
		}
	}

}


