/*
 * File: LetsGetIceCreamSoln.java
 * -----------------------
 * File that will find the times that your friends are
 * free for ice cream!
 */

import acm.program.*;

import java.util.*;
import java.io.*;

public class LetsGetIceCreamSoln extends ConsoleProgram {
	
	private static final String SENTINEL = "";


	public void run(){
		HashMap<String, ArrayList<String>> friendAvailability = new HashMap<String, ArrayList<String>>();
		ArrayList<String> bestTimes = new ArrayList<String>();
		
		println("Let's go get ice cream! When are you free? \n");
		
		// Add friends (fencepost)
		String name = readLine("What's your name?");
		while(!name.equals(SENTINEL)) {
			ArrayList<String> currFrientAvailability = new ArrayList<String>();
			
			// Add friend availability (fencepost)
			println("Format availabilities like: 1:20AM or 12:30PM");
			String time = readLine("Input one time you're free to get ice cream: ");
			while(!time.equals(SENTINEL)) {
				currFrientAvailability.add(time);
				time = readLine("Input another time you're free: ");
			}
			
			// Add friend and their availability to the map
			friendAvailability.put(name, currFrientAvailability);
			if(friendAvailability.size() == 1) {
				bestTimes.addAll(currFrientAvailability);
			} else {
				// this only saves the times these two ArryLists share
				bestTimes.retainAll(currFrientAvailability);
			}
			
			name = readLine("What's your name?");
			
		}
		
		// Loop through friends
		for(String currFriend : friendAvailability.keySet()) {
			println(currFriend + " is available at: ");
			
			ArrayList<String> currFriendAvailabilities = friendAvailability.get(currFriend);
			// Loop through friends' availability and print it!
			for(String time : currFriendAvailabilities) {
				println(time);
			}
		}
		
		// prints best times!
		println("Your friends are all available at: ");
		for(String time: bestTimes) {
			println(time);
		}
		
		
	}


}


