/*
 * File: PickingBerries.java
 * -----------------------
 * Empty version of a graphics program to pick berries off of a bush!
 * We'll use a HashMap to store how many of each berry we've picked.
 */

import acm.program.*;
import acm.util.*;
import acm.graphics.*;

import java.util.*;
import java.io.*;
import java.awt.event.*;
import java.awt.*;

public class PickingBerries extends GraphicsProgram {

	/* Constants for our program. We shouldn't need to hard code in anything! */
	private static final int NONE = 0;
	private static final int LEAF = 1;
	private static final int RASPBERRY = 2;
	private static final int BLUEBERRY = 3;
	private static final int BLACKBERRY = 4;
	
	private static final int ROW = 15;
	private static final int COL = 24;

	private static final String LEAF_IMAGE = "leaf.png";
	private static final String RASPBERRY_IMAGE = "raspberry.png";
	private static final String BLUEBERRY_IMAGE = "blueberry.png";
	private static final String BLACKBERRY_IMAGE = "blackberry.png";
	private static final int IMAGE_WIDTH = 30;
	
	/* Instance variables so we can edit our bush, berryCounts, and label inside of mouseClicked. */
	private int[][] bush = new int[ROW][COL];
	private HashMap<Integer, Integer> berryCounts = new HashMap<>();
	private GLabel berryLabel = new GLabel("");

	public void run(){
		// Given to you:
		setup();
		RandomGenerator rg = new RandomGenerator();
		
		// STEP 1:
		// Loop through your 2D array called bush and initialize every
		// index to a random value between NONE and BLACKBERRY
		
		// STEP 2:
		// Loop through the values of your 2D array
			// get the value from the array
			// create the right GImage based off of that value
			// then place the GImage in place using i or j times IMAGE_WIDTH
		
	}
	
	// STEP 3:
	public void mouseClicked(MouseEvent e) {
		int mouseX = e.getX();
		int mouseY = e.getY();
		
		GImage fruitImage = getElementAt(mouseX, mouseY);

		if(fruitImage != null){
			// calculateRow and calculateCol are given
			int row = calculateRow(fruitImage);
			int col = calculateCol(fruitImage);
			
			// get the fruitNum from the bush
			int fruitNum = bush[row][col];
			
			// if the fruit is not a leaf
				// if a berry exists in the map:
					// add one to its count
				// if a berry doesn't exist in the map:
					// add it to the map!
				
				// delete the berry from the bush
				// delete the GImage of the berry
				// update the Label	
		}
	}
	
	// STEP 4:
	private void updateLabel() {
		String labelString = "";
		
		// if berryCounts contains each type of berry
			// add information about that berry to the labelString!
		
		berryLabel.setLabel(labelString);		
	}
	
	
/* The below code is written for you. */
	
	/**
	 * Given a number, will return a GImage with proper image file.
	 * @param fruitType
	 * @return
	 */
	private GImage createFruitImage(int fruitType) {
		GImage fruitImage = null;
		if(fruitType == LEAF) {
			fruitImage = new GImage(LEAF_IMAGE);
		} else if (fruitType == RASPBERRY) {
			fruitImage = new GImage(RASPBERRY_IMAGE);
		} else if (fruitType == BLUEBERRY) {
			fruitImage = new GImage(BLUEBERRY_IMAGE);
		} else if (fruitType == BLACKBERRY) {
			fruitImage = new GImage(BLACKBERRY_IMAGE);
		}
		
		// If the bush image
		if(fruitImage != null) {
			fruitImage.setSize(IMAGE_WIDTH, IMAGE_WIDTH);
		}
		
		return fruitImage;
	}
	
	/**
	 * Sets up the GLabel and paints the bush background green.
	 */
	private void setup() {
		setBackground(new Color(29, 138, 28));
		berryLabel.setFont("Helvetica-24");
		add(berryLabel, 0, berryLabel.getAscent());
	}
	
	/**
	 * Given an object on the bush, will return the col it's in.
	 * @param bushObject
	 * @return
	 */
	private int calculateCol(GImage fruitImage) {
		double x = fruitImage.getX();
		return (int)(x / IMAGE_WIDTH);
	}
	
	/**
	 * Given an object on the bush, will return the row it's in.
	 * @param bushObject
	 * @return
	 */
	private int calculateRow(GImage fruitImage) {
		double y = fruitImage.getY();
		return (int)(y / IMAGE_WIDTH) - 1;
	}
	
	private int numRows(int[][] arr) {
		return arr.length;
	}
	
	private int numCols(int[][] arr) {
		return arr[0].length;
	}

}


