/* File: HedgehogShow.java
 * --------------------------
 * This file is an example program using the new variable
 * type we defined, Hedgehog.
 */
import java.util.ArrayList;

import acm.program.*;

public class HedgehogShow extends ConsoleProgram {
	public void run() {
		// make list of hedgehogs at the Hedgehog Show!
		ArrayList<Hedgehog> hedgehogs = new ArrayList<Hedgehog>();
		
		// make a Hedgehog
		Hedgehog polkaDot = new Hedgehog("Polka Dot", "playful", 5, "teardrop");
		
		// make another Hedgehog
		Hedgehog hufflepuff = new Hedgehog("Hufflepuff");
		hufflepuff.setAttitude("boisterous");
		hufflepuff.setShape("round");
		hufflepuff.setHealth(8);
		
		// and a third one!
		Hedgehog ruffles = new Hedgehog("Ruffles", "sassy", 3, "pear");
		ruffles.runAround();  // this increases health by 1
		ruffles.setAttitude("determined");
		
		// register them
		polkaDot.register();
		hufflepuff.register();
		ruffles.register();
		
		// let's add them to a list of Hedgehogs at the show
		hedgehogs.add(polkaDot);
		hedgehogs.add(hufflepuff);
		hedgehogs.add(ruffles);
		
		// print out info for each Hedgehog in the list
		for (Hedgehog hedgehog : hedgehogs) {
			println(hedgehog);   // invokes toString() method
		}		
	}
}
