/*
 * Decompiled with CFR 0.152.
 */
package acmx.export.javax.swing;

import acmx.export.javax.swing.KeyStroke;
import java.awt.Component;
import java.awt.MenuItem;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class JMenuItem
extends Component {
    private ArrayList<ActionListener> actionListeners;
    private ArrayList<ChangeListener> changeListeners;
    private MenuItem menuItem;
    private int shortcut;
    private KeyStroke shortkey;

    public JMenuItem() {
        this(null);
    }

    public JMenuItem(String name) {
        this(name, 0);
    }

    public JMenuItem(String name, int mnemonic) {
        this.menuItem = new MenuItem(name);
        this.shortcut = mnemonic;
        this.changeListeners = new ArrayList();
        this.actionListeners = new ArrayList();
    }

    public int getMnemonic() {
        return this.shortcut;
    }

    public void setMnemonic(int mnemonic) {
        this.shortcut = mnemonic;
    }

    public void setAccelerator(KeyStroke keystroke) {
        this.shortkey = keystroke;
    }

    public KeyStroke getAccelerator() {
        return this.shortkey;
    }

    public String getText() {
        return this.menuItem.getLabel();
    }

    public void setEnabled(boolean flag) {
        this.menuItem.setEnabled(flag);
        ChangeEvent e = new ChangeEvent(this);
        this.fireChangeListeners(e);
    }

    public void addChangeListener(ChangeListener listener) {
        this.changeListeners.add(listener);
    }

    public void addActionListener(ActionListener listener) {
        this.menuItem.addActionListener(listener);
        this.actionListeners.add(listener);
    }

    public void setActionCommand(String actionCommand) {
        this.menuItem.setActionCommand(actionCommand);
    }

    public void doClick(int delay) {
        if (delay != delay) {
            // empty if block
        }
        ActionEvent e = new ActionEvent(this, 1001, this.menuItem.getActionCommand());
        this.fireActionListeners(e);
    }

    protected int getItemCount() {
        return 0;
    }

    protected JMenuItem getItem(int index) {
        if (index != index) {
            // empty if block
        }
        return null;
    }

    protected void fireActionListeners(ActionEvent e) {
        int nListeners = this.actionListeners.size();
        int i = 0;
        while (i < nListeners) {
            this.actionListeners.get(i).actionPerformed(e);
            ++i;
        }
    }

    protected void fireChangeListeners(ChangeEvent e) {
        int nListeners = this.actionListeners.size();
        int i = 0;
        while (i < nListeners) {
            ((ChangeListener)((Object)this.actionListeners.get(i))).stateChanged(e);
            ++i;
        }
    }

    public ActionListener[] getActionListeners() {
        int nListeners = this.actionListeners.size();
        ActionListener[] array = new ActionListener[nListeners];
        int i = 0;
        while (i < nListeners) {
            array[i] = this.actionListeners.get(i);
            ++i;
        }
        return array;
    }

    protected MenuItem getMenuItem() {
        return this.menuItem;
    }
}

