import java.awt.Color;

import acm.graphics.GOval;
import acm.util.RandomGenerator;

public class Ball {

	private static final int BALL_SIZE = 20;

	// 1. what properties should a ball variable have?
	// our instance variables
	private GOval circle;
	private double dx;
	private double dy;

	// 2. what happens when we make a new ball?
	// call to constructor
	public Ball() {
		// make the ball's circle
		this.circle = new GOval(0, 0, BALL_SIZE, BALL_SIZE);
		this.circle.setFilled(true);
		this.circle.setColor(Color.BLUE);

		// gets a random dx and a random dy
		this.dx = getRandomSpeed();
		this.dy = getRandomSpeed();
	}
	
	// Public Method: Get GOval
	// Returns the ball's GOval
	public GOval getGOval() {
		// TODO: fill this in
		return this.circle;
	}

	// Public Method: Heartbeat
	// Animates one heartbeat
	public void heartbeat(int screenWidth, int screenHeight) {
		// TODO fill this in
		// move it incrementally
		this.circle.move(this.dx, this.dy);
		
		// bounce
		reflectOffWalls(screenWidth, screenHeight);
	}

	/**************************************************
	 *           PRIVATE METHODS                      *
	 **************************************************/

	private void reflectOffWalls(int screenWidth, int screenHeight) {
		if (hitLeftWall() || hitRightWall(screenWidth)) {
			this.dx *= -1;
		}
		if (hitTopWall() || hitBottomWall(screenHeight)) {
			this.dy *= -1;
		}
	}
	
	private boolean hitRightWall(int screenWidth) {
		return this.circle.getX() > screenWidth - BALL_SIZE;
	}

	private boolean hitLeftWall() {
		return this.circle.getX() < 0;
	}

	private boolean hitBottomWall(int screenHeight) {
		return this.circle.getY() > screenHeight - BALL_SIZE;
	}

	private boolean hitTopWall() {
		return this.circle.getY() < 0;
	}

	private double getRandomSpeed() {
		RandomGenerator rg = RandomGenerator.getInstance();
		double speed = rg.nextDouble(1,3);
		if(rg.nextBoolean()) {
			speed *= -1;
		}
		return speed;
	}
}
