
import java.awt.event.ActionEvent;
import java.util.*;

import javax.swing.*;

import acm.program.*;

public class BouncingBalls extends GraphicsProgram {

	private static final int DELAY = 3;
		
	private ArrayList<Ball> balls = new ArrayList<Ball>();
	
	public void init() {
		JButton ballButton = new JButton("Add ball");
		add(ballButton, SOUTH);
		addActionListeners();
	}
	
	public void run() {
		while(true) {
			animateBalls();
			pause(DELAY);
		}
	}
	
	public void actionPerformed(ActionEvent e) {
		// when user clicks on button, we need to make new ball
		makeNewBall();
	}
	
	private void makeNewBall() {		
		// make new ball
		Ball newBall = new Ball();
		
		// add to our list
		balls.add(newBall);
		
		// add GOval to the canvas
		add(newBall.getGOval());
	}
	
	private void animateBalls() {
		for (Ball ball : balls) {
			// move that individual ball incrementally
			ball.heartbeat(getWidth(), getHeight());
		}
	}

}