
public class Email {

	// what instance variables do we need?
	private String toAddress;	// every email has a recipient address
	private String subject;		// every email has a subject
	private String body;		// every email has a body (text)

	// Constructor: this is how you make a new email
	public Email(String toAddress, String subject) {
		this.toAddress = toAddress;
		this.subject = subject;
		this.body = "empty for now";
	}
	
	// for testing purposes it is useful to have a "toString" method
	// this neat method tells Java how to turn obj to String!
	public String toString() {
		String str = "";
		str += "toAddress: " + this.toAddress + "\n";
		str += "subject: " + this.subject + "\n";
		str += "body: " + this.body + "\n";
		return str;
	}

	// warning: actually sends an email!
	public void send() {
		// make a sender that will help us send the email
		EmailSender sender = new EmailSender();
		
		// send the email
		sender.send(this.toAddress, this.subject, this.body);
	}
	
	// sets the body of the email
	public void setBody(String newBody) {
		this.body = newBody;
	}
}