/*
 * File: SpreadTheWord.java
 * ---------------------
* This program sends emails to students! It leverages the 
 * new variable types Student and Email that we have created.
 */

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Scanner;

import acm.program.*;
import acm.util.RandomGenerator;

public class SpreadTheWord extends ConsoleProgram {

	// number of students to include in the email
	private static final int N_STUDENTS_IN_EMAIL = 5;

	// all the students in CS106A!
	private ArrayList<Student> allStudents = new ArrayList<Student>();

	// send those emails!
	public void run() {	
		// load all the students
		loadStudents();

		for (Student student : allStudents) {
			// make an email
			Email email = new Email(student.getEmail(), "Greetings from lecture");
			String body = generateSocialEmailText(student);
			email.setBody(body);
						
			// send email
			email.send();
			
			// print student we sent it to
			println(student); // toString
			
			pause(1);
		}
	}

	// sends a single email to test email account
	// to: cs106a.test@gmail.com
	private void runTest() {
		println("Sending test email");
		Email email = new Email("cs106a.test@gmail.com", "hi");
		println(email);	// for debugging
		email.send();
		println("SENT!");
	}

	// makes the body for our little experiment
	private String generateSocialEmailText(Student student) {
		// generate text for the email
		String body = "";
		body += "Dear " + student.getName() + ",\n\n";
		body += "I hope this email finds you well.\n\n";
		body += "As you know, CS106A is a huge class with many wonderful people in it. ";
		body += "In lecture today we built a program to help you meet a few fellow students. ";
		body += "Here are five random people in CS106A. ";
		body += "You can (optionally) introduce yourself:\n";

		// get 5 random students
		List<Student> randomStudents = getRandomStudents(N_STUDENTS_IN_EMAIL);
		for(Student other : randomStudents) {
			body += "   " + other.getName() + ", " + other.getEmail() + "\n";
		}

		body += "\n";
		body += "All the best,\n";
		body += "Laura (and Chris :))";
		body += "\n\n";
		body += "P.S. Today we covered 'classes' which introduces a whole new way of thinking about programs";
		return body;
	}

	// load all students from the file students.txt
	private void loadStudents() {
		try {
			//Scanner sc = new Scanner(new File("students.csv"));
			Scanner sc = new Scanner(new File("students.txt"));
			while(sc.hasNextLine()) {
				String line = sc.nextLine(); // Laura,xxx@stanford.edu
				String[] cols = line.split(",");
				
				String name = cols[0];          // Laura
				String emailAddress = cols[1];  // xxx@stanford.edu

				// create a student
				Student student = new Student(name, emailAddress);
				
				// add student to list
				allStudents.add(student);
			}
			sc.close();
		} catch (IOException e) {
			e.printStackTrace();
		}
	}

	// returns n random students (without replacement) from the list of
	// all students
	private List<Student> getRandomStudents(int n) {
		RandomGenerator rg = RandomGenerator.getInstance();
		List<Student> chosen = new ArrayList<Student>();
		while(chosen.size() < n) {
			int randIndex = rg.nextInt(allStudents.size());
			Student randStudent = allStudents.get(randIndex);
			// make sure the student isn't already in the list!
			if(!chosen.contains(randStudent)) {
				chosen.add(randStudent);
			}
		}
		return chosen;
	}

}

