/*
 * File: DrawingSoln.java
 * -----------------------
 * Finished class to store a simple drawing.
 */

import acm.graphics.*;
import java.util.*;

public class DrawingSoln{
		
	private String artist;
	private ArrayList<GObject> shapes;
	
	public DrawingSoln(String artist) {
		this.artist = artist;
		this.shapes = new ArrayList<>();
	}
	
	public String getArtist() {
		return this.artist;
	}
	
	public GObject getShapeAt(int index) {
		return this.shapes.get(index);
	}
	
	public void addShape(GObject shape) {
		this.shapes.add(shape);
	}
	
	public int numShapes() {
		return this.shapes.size();
	}
	
	public String toString(){
		return this.artist + ": shapes=" + this.shapes.toString();
	}
}


