/*
 * File: MadLibsSoln.java
 * -----------------------
 * Fun MadLibs game!
 */

import acm.program.*;
import javax.swing.*;
import java.awt.event.*;


public class MadLibsSoln extends ConsoleProgram {
		
	private JTextField nameField = new JTextField(15);
	private JTextField verbField = new JTextField(15);
	private JTextField feelingField = new JTextField(15);
	private JTextField codeField = new JTextField(15);

	public void init() {
		add(new JLabel("CS106A MadLibs!"), NORTH);
		add(new JLabel("Name"), WEST);
		add(nameField, WEST);
		add(new JLabel("Past Tense Verb"), WEST);
		add(verbField, WEST);
		add(new JLabel("Feeling"), WEST);
		add(feelingField, WEST);
		add(new JLabel("Coding Concept"), WEST);
		add(codeField, WEST);
		add(new JButton("Create"), WEST);
		addActionListeners();
	}

	public void run(){
		println("Fill in the blanks to create your MadLibs! \n");
	}
	
	public void actionPerformed(ActionEvent e) {
		String name = nameField.getText();
		String verb = verbField.getText();
		String feeling = feelingField.getText();
		String code = codeField.getText();
		
		createMadLib(name, verb, feeling, code);
	}
	
	private void createMadLib(String name, String verb, String feeling, String code) {
		clearConsole();
		println("On " + name + "'s first day of CS106A they accidentally woke up");
		println("late for class! They " + verb + " to class, but when " + name);
		println("arrived at Bishop Auditorium, no one was there! " + name + " felt ");
		println(feeling + ". Well, good thing no one uses " + code + " anyways.");
	}
}


