/*
 * File: MyDrawingProgramSoln.java
 * -----------------------
 * A fun drawing game that saves artists' drawings!
 */

import acm.program.*;
import acm.graphics.*;
import javax.swing.*;
import java.util.*;

import java.awt.Color;
import java.awt.event.*;
import acm.util.*;


public class MyDrawingProgramSoln extends GraphicsProgram implements MyDrawingProgramConstants {
		
	private JTextField nameField = new JTextField(15);
	private int currShapeType = CIRCLE;
	private HashMap<String, DrawingSoln> drawings = new HashMap<>();
	private DrawingSoln currDrawing;

	public void init() {
		add(new JLabel("Your Drawing"), NORTH);
		add(new JLabel("Name"), WEST);
		add(nameField, WEST);
		add(new JButton("Change Name"), WEST);
		add(new JButton("Circle"), SOUTH);
		add(new JButton("Rectangle"), SOUTH);
		addActionListeners();
	}
	
	public void actionPerformed(ActionEvent e) {
		if(e.getActionCommand().equals("Circle")){
			currShapeType = CIRCLE;
		} else if (e.getActionCommand().equals("Rectangle")){
			currShapeType = RECTANGLE;
		} else if(e.getActionCommand().equals("Change Name")) {
			String name = nameField.getText();
			removeAll();
			
			if(drawings.containsKey(name)) {
				currDrawing = drawings.get(name);
				for(int i = 0; i < currDrawing.numShapes(); i ++) {
					add(currDrawing.getShapeAt(i));
				}
			} else {
				currDrawing = new DrawingSoln(name);
			}
		}
	}
	
	public void mouseClicked(MouseEvent e) {
		int mouseX = e.getX();
		int mouseY = e.getY();
		
		if(currShapeType == CIRCLE) {
			GOval newCircle = randomColoredCircle();
			add(newCircle, mouseX, mouseY);
			if(currDrawing != null) {
				currDrawing.addShape(newCircle);
				drawings.put(nameField.getText(), currDrawing);
			}
			

		} else if (currShapeType == RECTANGLE) {
			GRect newRect = randomColoredRect();
			add(newRect, mouseX, mouseY);
			if(currDrawing != null) {
				currDrawing.addShape(newRect);
				drawings.put(nameField.getText(), currDrawing);
			}

		}
	}
	

/* The below code is given for you. */	
	
	/**
	 * Generates and returns a random color
	 * @return random color
	 */
	private Color getRandomColor() {
		RandomGenerator rg = new RandomGenerator();
		return rg.nextColor();
	}
	
	/**
	 * Creates a randomly colored circle.
	 * @return circle
	 */
	private GOval randomColoredCircle() {
		GOval newCircle = new GOval(CIRCLE_WIDTH, CIRCLE_WIDTH);
		newCircle.setFilled(true);
		newCircle.setColor(getRandomColor());
		return newCircle;
		
	}
	
	/**
	 * Creates a randomly colored rectangle.
	 * @return circle
	 */
	private GRect randomColoredRect() {
		GRect newRect = new GRect(RECTANGLE_WIDTH, RECTANGLE_WIDTH);
		newRect.setFilled(true);
		newRect.setColor(getRandomColor());
		return newRect;
		
	}
}


