/*
 * Decompiled with CFR 0.152.
 */
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.Map;
import java.util.TreeMap;

public class Request {
    private String command;
    private Map<String, String> params;

    public static String decode(String str) {
        try {
            return URLDecoder.decode(str, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public static String encode(String str) {
        try {
            return URLEncoder.encode(str, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public Request(String cmd) {
        if (!this.isCommandValid(cmd)) {
            throw new RuntimeException("The command \"" + cmd + "\" is not valid.");
        }
        this.command = cmd;
        this.params = new TreeMap<String, String>();
    }

    public String getCommand() {
        return this.command;
    }

    public boolean hasParam(String key) {
        return this.params.containsKey(key);
    }

    public String getParam(String key) {
        if (!this.hasParam(key)) {
            return null;
        }
        return Request.decode(this.params.get(key));
    }

    public void addParam(String key, String value) {
        this.params.put(key, Request.encode(value));
    }

    public void addRaw(String key, String value) {
        this.params.put(key, value);
    }

    public String getRaw(String key) {
        return this.params.get(key);
    }

    public String toString() {
        String str = String.valueOf(this.command) + " (";
        boolean isFirst = true;
        for (String p : this.params.keySet()) {
            if (!isFirst) {
                str = String.valueOf(str) + ", ";
            }
            str = String.valueOf(str) + p + "=" + this.getParam(p);
            isFirst = false;
        }
        str = String.valueOf(str) + ")";
        return str;
    }

    public String toGetRequest() {
        String getRequest = this.command;
        if (!this.params.isEmpty()) {
            boolean isFirst = true;
            for (String key : this.params.keySet()) {
                if (isFirst) {
                    getRequest = String.valueOf(getRequest) + "?" + key + "=" + this.params.get(key);
                    isFirst = false;
                    continue;
                }
                getRequest = String.valueOf(getRequest) + "&" + key + "=" + this.params.get(key);
            }
        }
        return getRequest;
    }

    private boolean isCommandValid(String cmd) {
        if (cmd.isEmpty()) {
            return false;
        }
        if (cmd.contains("?")) {
            return false;
        }
        return !cmd.contains(" ");
    }
}

