/*
 * Decompiled with CFR 0.152.
 */
import acm.graphics.GImage;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.ConnectException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Base64;
import javax.imageio.ImageIO;

public class SimpleClient {
    private static final String ERROR_KEY = "Error";

    public static String makeRequest(String host, Request request) throws IOException {
        host = SimpleClient.sanitizeHost(host);
        try {
            String fromServer = SimpleClient.makeGetRequest(host, request);
            if (fromServer.startsWith(ERROR_KEY)) {
                String msg = SimpleClient.sanitizeErrorMsg(fromServer);
                throw new IOException(msg.trim());
            }
            return fromServer;
        }
        catch (ConnectException e) {
            throw new ConnectException("Unable to connect to the server. Did you start it?");
        }
    }

    public static GImage getImage(String host, String fileName) {
        try {
            host = SimpleClient.sanitizeHost(host);
            URL url = new URL(String.valueOf(host) + "images/" + fileName);
            BufferedImage image = ImageIO.read(url);
            return new GImage((Image)image);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static String saveImage(String host, String fileName, int width, int height) {
        host = SimpleClient.sanitizeHost(host);
        try {
            byte[] bytes = SimpleClient.getImageByteArray(fileName, width, height);
            String contents = Base64.getUrlEncoder().encodeToString(bytes);
            Request r = new Request("saveImage");
            r.addParam("fileName", fileName);
            r.addParam("file", contents);
            return SimpleClient.makeGetRequest(host, r);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static String makeGetRequest(String host, Request r) throws IOException {
        URL destination = new URL(String.valueOf(host) + r.toGetRequest());
        HttpURLConnection conn = (HttpURLConnection)destination.openConnection();
        conn.setRequestMethod("GET");
        BufferedReader rd = new BufferedReader(new InputStreamReader(conn.getInputStream()));
        String line = null;
        StringBuilder result = new StringBuilder();
        while ((line = rd.readLine()) != null) {
            result.append(line);
        }
        String fromServer = result.toString();
        rd.close();
        return fromServer;
    }

    private static byte[] getImageByteArray(String fileName, int width, int height) throws IOException {
        GImage toSend = new GImage(fileName);
        Image original = toSend.getImage();
        BufferedImage newImage = new BufferedImage(width, height, 1);
        Graphics2D g = newImage.createGraphics();
        g.drawImage(original, 0, 0, width, height, null);
        g.dispose();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ImageIO.write((RenderedImage)newImage, "jpg", byteArrayOutputStream);
        byte[] bytes = byteArrayOutputStream.toByteArray();
        return bytes;
    }

    private static String sanitizeErrorMsg(String fromServer) {
        String msg = fromServer.substring(ERROR_KEY.length());
        while (SimpleClient.startsWithPunctuation(msg)) {
            msg = msg.substring(1);
        }
        return msg.trim();
    }

    private static boolean startsWithPunctuation(String msg) {
        if (msg.isEmpty()) {
            return false;
        }
        return !Character.isLetterOrDigit(msg.charAt(0));
    }

    private static String sanitizeHost(String host) {
        if (!host.endsWith("/")) {
            host = String.valueOf(host) + "/";
        }
        return host;
    }
}

