/*
 * EchoServer.java
 * ---------------
 * This implements a simple server that prints how long
 * the command sent to the server is.
 */

import acm.program.ConsoleProgram;

public class EchoServer extends ConsoleProgram implements SimpleServerListener{

	// 1. make a server object
	private SimpleServer server = new SimpleServer(this, 8080);

	public void run() {
		// 2. start the server
		server.start();
		println("Starting server...");
	}

	public void init() {
		setFont("Courier-24");
	}

	// 3. implement requestMade
	public String requestMade(Request request) {
		String cmd = request.getCommand();
		
		println(request);
		
		return "Command was " + cmd.length() + " chars long";
	}
}