/* File: PollClient.java
 * -------------------------
 * This file is the client program for a Trivia game.  It displays
 * 4 buttons for A/B/C/D and when the user clicks one of them, it
 * sends a request over the Internet to the main game program with
 * our vote. 
 */

import acm.program.*;
import java.awt.event.*;
import java.io.IOException;
import javax.swing.*;

public class PollClient extends ConsoleProgram {

	// The URL where the host program is running
	private static final String HOST = "http://localhost:8080";

	public void init() {
		setFont("Courier-24");
		
		// Add interactors
		add(new JLabel("Your answer: "), SOUTH);
		add(new JButton("A"), SOUTH);
		add(new JButton("B"), SOUTH);
		add(new JButton("C"), SOUTH);
		add(new JButton("D"), SOUTH);
		addActionListeners();
	}
	
	// When the user clicks a button, send a new Request with our vote
	public void actionPerformed(ActionEvent e) {
		try {
			Request request = new Request("vote");
			String answer = e.getActionCommand();
			request.addParam("answer", answer);
			String response = SimpleClient.makeRequest(HOST, request);
			println(response);	
		} catch (IOException ex) {
			println("The internet is a wild place...");
			ex.printStackTrace();
		}	
	}
}
