/*
 * File: JSoupExampleSoln.java
 * ---------------------
 * This will read HTML from an explore courses URL
 * and list all of the course titles from that page!
 */

import java.io.*;
import java.net.*;

import org.jsoup.Jsoup;
import org.jsoup.nodes.*;
import org.jsoup.select.*;

public class JSoupExampleSoln{
	
	public static void main(String[] args) {
		// Using Java's URL library to get code from explore courses
		String HTML = getSite();
		// Use JSoup
		Document parsedHTML = Jsoup.parse(HTML);
		// get title from webpage
		String title = parsedHTML.title(); 
		// get everything on the webpage with class="courseTitle"
		Elements courseTitles = parsedHTML.select(".courseTitle");
		// print out data!
		System.out.println(title);
		for(Element courseTitle:courseTitles) {
			System.out.println(courseTitle.text());
		}
	}
	
	private static String getSite() {
		    InputStream is = null;
		    String HTML= "";

		    try {
		    	String exporeCoursesURL = "https://explorecourses.stanford.edu/search?view=catalog&filter-coursestatus-Active=on&page=0&catalog=&academicYear=&q=CS&collapse=";
		        URL url = new URL(exporeCoursesURL);
		        is = url.openStream();  // throws an IOException
		        BufferedReader br = new BufferedReader(new InputStreamReader(is));
		        
		        String line;
		        while ((line = br.readLine()) != null) {
		            HTML += line;
		        }
		    } catch (MalformedURLException mue) {
		         mue.printStackTrace();
		    } catch (IOException ioe) {
		         ioe.printStackTrace();
		    } finally {
		        try {
		            if (is != null) is.close();
		        } catch (IOException ioe) {
		            // nothing to see here
		        }
		    }
		    return HTML;
		
	}
}

