/* FILE: MLImage
 * -------------
 * This class represents a "Machine Learning" image,
 * which packages up information about a single image.
 * 
 * Specifically, an MLImage contains a GImage for the
 * actual image, the digit displayed in the image,
 * the pixel array (so we don't have to ask the GImage
 * for it each time, which makes it faster) and
 * the list of the K nearest neighbors for this image.
 */

import acm.graphics.GImage;

public class MLImage {
	private GImage image;
	private int label;
	private int[][] pixels;
	private MLImage[] kNearestNeighbors;
	
	// This constructor makes an MLImage with the given GImage and label.
	public MLImage(GImage image, int label) {
		this.image = image;
		this.label = label;
		this.pixels = image.getPixelArray();
	}
	
	// This method returns the image within this MLImage.
	public GImage getImage() {
		return image;
	}
	
	// This method returns the digit displayed in this MLImage.
	public int getLabel() {
		return label;
	}
	
	// This method returns the pixel array of the contained image.
	public int[][] getPixelArray() {
		return pixels;
	}
	
	// This method returns the list of nearest neighbors for this image.
	public MLImage[] getKNearestNeighbors() {
		return kNearestNeighbors;
	}
	
	// This method sets the list of nearest neighbors for this image.
	public void setKNearestNeighbors(MLImage[] neighbors) {
		kNearestNeighbors = neighbors;
	}
}
