/*
 * File: TalkToMe.java
 * ---------------------
 * This implements a regular expression (regex) to find
 * specific words and phrases in text.
 */

import java.util.Scanner;
import java.util.regex.*;

public class TalkToMe{
	public static void main(String[] args) {
		// String to be scanned to find the pattern.
		String nameString = "[Mm]y name is ([a-zA-Z]+).?";
		Scanner console = new Scanner(System.in);

		System.out.println("Talk to me!");
		String line = console.nextLine();
		while(!line.equals("")) {

			// Create a Pattern object
			Pattern namePattern = Pattern.compile(nameString);

			// Now create matcher object to detect matches
			Matcher nameMatches = namePattern.matcher(line);
			if (nameMatches.find( )) {
				// .group(1) gives you the found name
				String name = nameMatches.group(1);
				System.out.println("Hello " + name);
			}else {
				System.out.println("Hmmm... okay.");
			}

			System.out.println("Talk to me!");
			line = console.nextLine();
		}
		
		console.close();
	}

}

