/*
 * File: TalkToMeSoln.java
 * ---------------------
 * This implements a regular expression (regex) to find
 * specific words and phrases in text.
 */

import java.util.Scanner;
import java.util.regex.*;

public class TalkToMeSoln{
	public static void main(String[] args) {
		// String to be scanned to find the pattern.
		String nameString = "[Mm]y name is ([a-zA-Z]+).?";
		String feelingString = "feel(ing)? ([a-zA-Z]+).?";
		String likeString = "[iI] like ([a-zA-Z0-9]+).?";
		
		Scanner console = new Scanner(System.in);

		System.out.println("Talk to me!");
		String line = console.nextLine();
		while(!line.equals("")) {

			// Create a Pattern object
			Pattern namePattern = Pattern.compile(nameString);
			Pattern feelingPattern = Pattern.compile(feelingString);
			Pattern likePattern = Pattern.compile(likeString);

			// Now create matcher object to detect matches
			Matcher nameMatches = namePattern.matcher(line);
			Matcher feelingMatches = feelingPattern.matcher(line);
			Matcher likeMatches = likePattern.matcher(line);
			if (nameMatches.find( )) {
				// .group(1) gives you the found name
				String name = nameMatches.group(1);
				System.out.println("Hello " + name);
			}else if (feelingMatches.find( )) {
				// .group(2) gives you the found feeling
				String name = feelingMatches.group(2);
				System.out.println("Hm, I see you feel " + name);
			} else if (likeMatches.find()) {
				String like = likeMatches.group(1);
				System.out.println("You like " + like);
			} else {
				System.out.println("Hmmm... okay.");
			}

			System.out.println("Talk to me!");
			line = console.nextLine();
		}
		
		console.close();
	}

}

