/*
 * File: BlankClass.java
 * ---------------------
 * This class is a blank one that you can change at will. Remember, if you
 * change the class name, you'll need to change the filename so that it matches.
 */

import java.awt.event.*;

import javax.swing.JButton;

import acm.graphics.*;
import acm.program.*;
import acm.util.RandomGenerator;

public class ShapesProgram extends GraphicsProgram {

	// CONSTANTS AND INSTANCE FIELDS GO HERE!
	public static final int MIN_RADIUS = 10;
	public static final int MAX_RADIUS = 75;
	private int state = 0;
	private RandomGenerator rgen;

	/**
	 * This program will eventually have three buttons which allow
	 * users to draw, move, and delete circles on screen.
	 */
	public void init() {

		// -------------- SECTION FOR INTERACTOR SETUP --------------
		add(new JButton("Edit"), SOUTH);
		add(new JButton("Circle"), SOUTH);
		add(new JButton("Delete"), SOUTH);
		addActionListeners();

		// ------------------ OTHER THINGS SETUP ------------------
		rgen = RandomGenerator.getInstance();
	}


	/**
	 * For handling button presses!
	 */
	public void actionPerformed(ActionEvent event) {
		String command = event.getActionCommand();
		if (command.equals("Edit")) {

		} else if (command.equals("Circle")) {

		} else if (command.equals("Delete")) {

		} else {
			throw new RuntimeException("Error: An event we didn't recognize.");
		}
	}


	/**
	 * What do we do when the mouse is clicked?
	 */
	public void mouseClicked(MouseEvent e) {
		int x = e.getX();
		int y = e.getY();
	}


	/**
	 * How about when the mouse is dragged?
	 */
	public void mouseDragged(MouseEvent e) {
		int x = e.getX();
		int y = e.getY();
	}


	/**
	 * And what about when it is released?
	 */
	public void mouseReleased(MouseEvent e) {
		int x = e.getX();
		int y = e.getY();
	}
	
	
	/**
	 * A simple 2D coordinate class for keeping track
	 * of a pair of Cartesian plane points. (Hint: use
	 * this for your offset!)
	 */
	private class Coordinate {
		private int x;
		private int y;
		
		private Coordinate() {
			this.x = 0;
			this.y = 0;
		}
		
		private Coordinate(int x, int y) {
			this.x = x;
			this.y = y;
		}
		
		private void setX(int x) {
			this.x = x;
		}
		
		private void setY(int y) {
			this.y = y;
		}
		
		private int getX() {
			return this.x;
		}
		
		private int getY() {
			return this.y;
		}
	}
}

