/*
 * File: BlankClass.java
 * ---------------------
 * This class is a blank one that you can change at will. Remember, if you
 * change the class name, you'll need to change the filename so that it matches.
 */

import java.awt.event.*;

import javax.swing.JButton;

import acm.graphics.*;
import acm.program.*;
import acm.util.RandomGenerator;

public class ShapesProgramSoln extends GraphicsProgram {

	// CONSTANTS AND INSTANCE FIELDS GO HERE!
	public static final int MIN_RADIUS = 10;
	public static final int MAX_RADIUS = 75;
	private RandomGenerator rgen;
	private static int state;
	private GOval selected;
	private Coordinate offset;

	/**
	 * This program will eventually have five buttons which allow
	 * users to draw, move, and delete shapes on screen.
	 */
	public void init() {

		// -------------- SECTION FOR INTERACTOR SETUP --------------
		add(new JButton("Edit"), SOUTH);
		add(new JButton("Circle"), SOUTH);
		add(new JButton("Delete"), SOUTH);
		addActionListeners();

		// ------------------ OTHER THINGS SETUP ------------------
		state = 0;
		rgen = RandomGenerator.getInstance();
		offset = new Coordinate();
	}


	/**
	 * For handling button presses!
	 */
	public void actionPerformed(ActionEvent event) {
		String command = event.getActionCommand();
		if (command.equals("Edit")) {
			state = 0;
		} else if (command.equals("Circle")) {
			state = 1;
		} else if (command.equals("Delete")) {
			state = 2;
		} else {
			throw new RuntimeException("Error: An event we didn't recognize.");
		}
	}


	/**
	 * What do we do when the mouse is clicked?
	 */
	public void mouseClicked(MouseEvent e) {
		int x = e.getX();
		int y = e.getY();

		// If we're in edit mode, try to select an object.
		if (state == 0) {
			selected = getElementAt(x, y);
			if (selected != null) {
				offset.setX(x - (int)selected.getX());
				offset.setY(y - (int)selected.getY());
			}
		
		// Create new Circle and add it! :)
		} else if (state == 1) {
			int radius = rgen.nextInt(MIN_RADIUS, MAX_RADIUS + 1);
			GOval circle = new GOval(x - radius, y - radius, 2 * radius, 2 * radius);
			circle.setFillColor(rgen.nextColor());
			circle.setFilled(true);
			add(circle);
			
		// Otherwise, see if there's a circle we've clicked on, and if so, delete it!
		} else if (state == 2) {
			GOval tempRef = getElementAt(x, y);
			if (tempRef != null) {
				remove(tempRef);
			}
		}
	}


	/**
	 * How about when the mouse is dragged?
	 */
	public void mouseDragged(MouseEvent e) {
		int x = e.getX();
		int y = e.getY();
		
		if (state == 0 && selected != null) {
			selected.setX(x - offset.getX());
			selected.setY(y - offset.getY());
			add(selected);
		}
	}


	/**
	 * And what about when it is released?
	 */
	public void mouseReleased(MouseEvent e) {
		int x = e.getX();
		int y = e.getY();
		
		// If we're currently editing something, just drop it! :)
		if (state == 0 && selected != null) {
			selected = null;
			offset.setX(0);
			offset.setY(0);
		}
	}
	
	
	/**
	 * A simple 2D coordinate class for keeping track
	 * of a pair of Cartesian plane points.
	 */
	private class Coordinate {
		private int x;
		private int y;
		
		private Coordinate() {
			this.x = 0;
			this.y = 0;
		}
		
		private Coordinate(int x, int y) {
			this.x = x;
			this.y = y;
		}
		
		private void setX(int x) {
			this.x = x;
		}
		
		private void setY(int y) {
			this.y = y;
		}
		
		private int getX() {
			return this.x;
		}
		
		private int getY() {
			return this.y;
		}
	}
}

