/*
 * File: CountingByBeepersSoln.java
 * ---------------------
 * In this program, Karel will place beepers in a decreasing order.
 * Example:| 5 | 4 | 3 | 2 | 1 | beepers in each consecutive corner.
 */

import stanford.karel.*;

public class CountingByBeepersSoln extends SuperKarel {
	
	public void run() {
		placeDecreasingBeepers();
	}
	
	/*
	 * Karel will place beepers in a decreasing number in a row.
	 * Pre: Karel is at the end of the row of beepers.
	 * Post: Karel is at (1, 1)
	 */
	private void placeDecreasingBeepers() {
		while(frontIsClear()) {
			turnAround();
			findWall();
			placeRowOfBeepers();
			
		}		
	}
	
	/*
	 * Karel will move until Karel finds a wall.
	 * Pre: Any
	 * Post: Karel's back is to a wall.
	 */
	private void findWall() {
		while(frontIsClear()) {
			move();
		}
		turnAround();
	}
	 
	/*
	 * Karel will place a row of beepers until Karel encounters an 
	 * empty space. Then Karel will place a final beeper in the 
	 * empty space.
	 * Pre: Karel is at the beginning of the row of beepers.
	 * Post: Karel is at the end of the row of beepers.
	 */
	private void placeRowOfBeepers() {
		while(frontIsClear() && beepersPresent()) {
			putBeeper();
			move();
		}
		putBeeper();
	}
}

