/*
 * File: CheckerBoard.java
 * -----------------
 * Draws a checkerboard with alternating black and white tiles.
 */

import acm.graphics.*;
import acm.program.*;
import java.awt.*;

public class Checkerboard extends GraphicsProgram {	

	/* The size of a single square on the board */
	private static final int SQUARE_SIZE = 50;
	
	/* Number of rows */
	private static final int NROWS = 8;
	
	/* Number of cols */
	private static final int NCOLS = 8;

	public void run() {
		
		drawCheckerboard();
		
	}
	
	private void drawCheckerboard() {
		for(int r = 0; r < NROWS; r++) {
			for(int c = 0; c < NCOLS; c++) {
				GRect rect = new GRect(SQUARE_SIZE, SQUARE_SIZE);
				boolean isFilled = (r + c) % 2 == 1;
				rect.setFilled(isFilled);
				add(rect, SQUARE_SIZE * c, SQUARE_SIZE * r);
			}
		}
		
		
	}
}