/*
 * File: CenterMe.java
 * ---------------------
 * This program adds a centered rectangle to the canvas.
 */

import java.awt.Color;

import acm.graphics.*;
import acm.program.*;

public class CenterMe extends GraphicsProgram {
		
	private static final double WIDTH = 300;
	private static final double HEIGHT = 100;
	
	public void run() {
		double x = (getWidth() - WIDTH) / 2.0;
		double y = (getHeight() - HEIGHT) / 2.0;
		
		GRect square = new GRect(x, y, WIDTH, HEIGHT);
		square.setFilled(true);
		square.setColor(Color.BLUE);
		
		add(square);
	}
}



















