/*
 * File: Stoplights.java
 * -----------------
 * A program that uses a decomposed method to draw one
 * or more "stoplight" graphics that each consist of a series of
 * red-yellow-green lights on a gray background.
 */

import acm.program.*;
import acm.graphics.*;
import java.awt.*;

public class Stoplights extends GraphicsProgram {
	public void run() {
		// Could call addStoplight with different coordinates / more times here
		addStoplight(50, 50, 100);    // Note: in practice, good to use constants
		addStoplight(200, 50, 50);
	}
	
	/** 
	 * addStoplight
	 * ------------
	 * This method adds a stoplight that contains a RED-YELLOW-GREEN
	 * "light" sequence represented by 3 colored GOvals,
	 * with the given x/y coordinates and width.
	 */
	private void addStoplight(double x, double y, double width) {
		// make grey background
		GRect background = new GRect(x, y, width, 3 * width);
		background.setFilled(true);
		background.setFillColor(Color.GRAY);
		add(background);
		
		// add 3 circles
		addColoredCircle(x, y, width, Color.RED);
		addColoredCircle(x, y + width, width, Color.YELLOW);
		addColoredCircle(x, y + 2 * width, width, Color.GREEN);
	}
	
	/** 
	 * addColoredCircle
	 * ----------------
	 * Adds a filled, colored circle to the canvas with
	 * the given coordinates, diameter and fill color.
	 */
	private void addColoredCircle(double x, double y, double size, Color color) {
		GOval light = new GOval(x, y, size, size);
		light.setFilled(true);
		light.setColor(color);
		add(light);
	}
}
