/*
 * File: MovingSquare.java
 * -----------------------
 * Animates a moving square. The square starts at the center
 * of the screen, then moves right.
 */

import java.awt.Color;

import acm.graphics.*;
import acm.program.*;

public class MovingSquare extends GraphicsProgram {

	/* ms to pause between heart-beats */
	private static final int DELAY = 6;
	
	/* the horizontal velocity of the square */
	private static final double VX = 2;
	
	/* width and the height of our moving square */
	private static final int SQUARE_SIZE = 100;
	
	public void run() {	
		// setup
		GRect square = makeSquare();
		
		while (true) {
			// update world
			square.move(VX, 0);
		
			// pause
			pause(DELAY);
		}
	}
	
	/* 
	 * Make a square and add it to the center of the screen. 
	 * Return the square so that the caller can animate it!
	 */
	private GRect makeSquare() {
		double x = getWidth() / 2.0 - SQUARE_SIZE / 2.0;
		double y = getHeight() / 2.0 - SQUARE_SIZE / 2.0;
		GRect rect = new GRect(x, y, SQUARE_SIZE, SQUARE_SIZE);
		rect.setFilled(true);
		rect.setColor(Color.BLUE);
		add(rect);
		return rect;
	}
}
