/*
 * File: Piglet.java
 * --------------------
 * This program plays the 1-player dice game “Piglet”.  Each turn,
 * the player rolls a dice – if it’s a 1, then the game is over and
 * they get a score of 0.  Otherwise, the value is added to their
 * total and the player chooses whether or not to roll again.  The
 * player tries to get the highest score possible.
 */

import acm.program.*;
import acm.util.*;       // for RandomGenerator

public class Piglet extends ConsoleProgram {
    public void run() {
        println("Welcome to Piglet!");
        int sum = 0;
        boolean rollAgain = true;

        int die = RandomGenerator.getInstance().nextInt(1, 6);
        println("You rolled a " + die + "!");

        // Loop until either we roll a 1 or the player doesn't want to re-roll.         
        while (die != 1 && rollAgain) {
            sum += die;
            rollAgain = readBoolean("Roll again?", "yes", "no");
            if (rollAgain) {
                die = RandomGenerator.getInstance().nextInt(1, 6);
                println("You rolled a " + die + "!");
            }
        }
        if (die == 1) {
            sum = 0;
        }
        println("You got " + sum + " points.");
    }
}

