/*
 * File: ClassPresidents.java
 * --------------------
 * Tallies up the votes for each candidate for the junior
 * and senior classes, and outputs the winners.
 */

import java.io.*;
import java.util.*;

import acm.program.*;

public class ClassPresidents extends ConsoleProgram {

	public void run() {
		try {
			Scanner input = new Scanner(new File("class_presidents.txt"));
			classPresidents(input);
			input.close();
		} catch (FileNotFoundException e) {
			println("File not found.");
		}
	}

	private void classPresidents(Scanner input) {
		String sophomorePresident = "";
		int maxSophomoreVotes = 0;
		String juniorPresident = "";
		int maxJuniorVotes = 0;

		while (input.hasNext()) {
			String name = input.next();
			String classLetter = input.next();
			int votes = input.nextInt();
			if (classLetter.equals("s")) {
				if (votes > maxSophomoreVotes) {
					sophomorePresident = name;
					maxSophomoreVotes = votes;
				}
			} else if (classLetter.equals("j")) {
				if (votes > maxJuniorVotes) {
					juniorPresident = name;
					maxJuniorVotes = votes;
				}
			}
		}
		println("Sophomore Class President: " + sophomorePresident + " (" +
				maxSophomoreVotes + " votes)");

		println("Junior Class President: " + juniorPresident + " (" +
				maxJuniorVotes + " votes)");
	}

}

