/*
 * File: NegativeSum.java
 * -----------------------
 * Determines whether the sum of a list of numbers is ever negative.
 */

import java.io.*;
import java.util.*;

import acm.program.*;

public class NegativeSum extends ConsoleProgram {

	public void run() {
		try {
			Scanner input = new Scanner(new File("negatives.txt"));
			negativeSum(input);
			input.close();
		} catch (FileNotFoundException e) {
			println("File not found.");
		}
	}

	private boolean negativeSum(Scanner input) {
		int sum = 0;
		int count = 0;
		while (input.hasNextInt()) {
			int next = input.nextInt();
			sum += next;
			count++;
			if (sum < 0) {
				println(sum + " after " + count + " steps");
				return true;
			}
		}

		println("No negative sum");
		return false;
	}

}

