/*
 * File: PigLatin.java
 * --------------------
 * Converts input text file to Pig Latin.
 */

import java.io.*;
import java.util.*;

import acm.program.*;

public class PigLatin extends ConsoleProgram {

	public void run() {
		try {
			Scanner input = new Scanner(new File("hamilton.txt"));
			pigLatin(input);
			input.close();
		} catch (FileNotFoundException e) {
			println("File not found.");
		}
	}

	// Given a text file, this method outputs the file as simplified Pig Latin.
	private void pigLatin(Scanner input) {
		while (input.hasNextLine()) {
			String line = input.nextLine();
			Scanner lineScanner = new Scanner(line);
			while (lineScanner.hasNext()) {
				String word = lineScanner.next();
				if (isVowel(word.charAt(0))) {
					print(word + "yay ");
				} else {
					print(word.substring(1) + word.charAt(0) + "ay ");
				}
			}
			lineScanner.close();
			println();
		}
	}

	// Given a text file, this method outputs the file as full Pig Latin.
	private void fullPigLatin(Scanner input) {
		while (input.hasNextLine()) {
			String line = input.nextLine();
			Scanner lineScanner = new Scanner(line);
			while (lineScanner.hasNext()) {
				String word = lineScanner.next();
				if (isVowel(word.charAt(0))) {
					print(word + "yay ");
				} else {
					// Find the start of the word beyond the first consonants
					int startIndex = 0;
					while (startIndex < word.length() &&
							!isVowel(word.charAt(startIndex))) {
						startIndex++;
					}
					print(word.substring(startIndex) + word.substring(0, startIndex));
					print("ay ");
				}
			}
			lineScanner.close();
			println();
		}
	}

	// This method returns whether the letter is aeiou (case insensitive)
	private boolean isVowel(char letter) {
		char lowerCaseLetter = Character.toLowerCase(letter);
		return lowerCaseLetter == 'a' || lowerCaseLetter == 'e' ||
		lowerCaseLetter == 'i' || lowerCaseLetter == 'o' ||
		lowerCaseLetter == 'u';
	}



}

